/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.CarpetServer;
import carpet.script.argument.FileArgument;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import org.apache.commons.io.IOUtils;

public record Module(String name, String code, boolean library) {
    public Module {
        Objects.requireNonNull(name);
        Objects.requireNonNull(code);
    }

    public static Module fromPath(Path path) {
        boolean library = path.getFileName().toString().endsWith(".scl");
        try {
            String name = path.getFileName().toString().replaceFirst("\\.scl?", "").toLowerCase(Locale.ROOT);
            String code = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
            return new Module(name, code, library);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load scarpet module", e);
        }
    }

    public static Module carpetNative(String scriptName, boolean isLibrary) {
        return Module.fromJarPath("assets/carpet/scripts/", scriptName, isLibrary);
    }

    public static Module fromJarPath(String path, String scriptName, boolean isLibrary) {
        return Module.fromJarPathWithCustomName(path + scriptName + (isLibrary ? ".scl" : ".sc"), scriptName, isLibrary);
    }

    public static Module fromJarPathWithCustomName(String fullPath, String customName, boolean isLibrary) {
        try {
            String name = customName.toLowerCase(Locale.ROOT);
            String code = IOUtils.toString((InputStream)Module.class.getClassLoader().getResourceAsStream(fullPath), (Charset)StandardCharsets.UTF_8);
            return new Module(name, code, isLibrary);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load bundled module", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_2520 getData(Module module) {
        Path dataFile = Module.resolveResource(module);
        if (dataFile == null) {
            return null;
        }
        if (!Files.exists(dataFile, new LinkOption[0]) || !Files.isRegularFile(dataFile, new LinkOption[0])) {
            return null;
        }
        Object object = FileArgument.writeIOSync;
        synchronized (object) {
            return FileArgument.readTag(dataFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveData(Module module, class_2520 globalState) {
        Path dataFile = Module.resolveResource(module);
        if (dataFile == null) {
            return;
        }
        if (!Files.exists(dataFile.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        Object object = FileArgument.writeIOSync;
        synchronized (object) {
            FileArgument.writeTagDisk(globalState, dataFile, false);
        }
    }

    private static Path resolveResource(Module module) {
        if (module == null) {
            return null;
        }
        return CarpetServer.minecraft_server.method_27050(class_5218.field_24188).resolve("scripts/" + module.name() + ".data.nbt");
    }
}

